#ifndef	BATTERY_METER_H
#define BATTERY_METER_H

// Some Constants
#define VERSION 		(7.30)
//
// EEPROM control
//
#define NUM_SETTINGS	        (32)
#define SETTINGS_OFFSET	        (16)
#define NUM_BYTESETTINGS		(9)
#define BYTESETTINGS_OFFSET		(240)
#define CYCLES_ADR				(16)
//
#define LCDCOMMAND 		0
#define LCDDATA			1
#define LCDE			(PORTCbits.RC0)
#define LCDRS			(PORTCbits.RC1)
#define USBSENSE		(PORTCbits.RC7)
#define INIT_TRISC		0x80
#define INIT_TRISB		0x0F
#define POWERON			(PORTAbits.RA5)
#define POWERONTRIS		(TRISAbits.TRISA5)
#define RELAYON			(PORTAbits.RA4)
#define RELAYONTRIS		(TRISAbits.TRISA4)
#define BUTTON			(PORTEbits.RE3)
#define BEEP			(PORTCbits.RC6)
#define FOSC4			(12000000.0)			// =MIPS, System Clock= 48 Mhz/4=12MHz
//
#define LCD_SIZE			32
#define LCD_DELAY			300				// should not be lower than about 70...
#define ADC_DELAY			20
#define KEY_BUFFER_SIZE		8
#define KEY_HOLD_OFF		4
// Analog Channel Definitions
#define ANCH_VBATTNEG		3
//#define ANCH_VUSB			4
#define ANCH_VBATTPOS		2
#define ANCH_INEG			0
#define ANCH_IPOS			1
#define COMPUTE_STATE		4
#define RLE_STATE			5
#define NUM_SAMPLES			6
#define DELTAT				(NUM_SAMPLES*65536.0/FOSC4)		// time between samples in seconds
//
#define	RLE_CHANNELS					4
#define MAX_RLE_MULTIPLICITY			16380   // must be lesss than all 1's eg. in this case must be less than 16384
#define RLE_CHANNEL_MASK				3
#define RLE_COMPLEMENT_MASK				0x3FFF
#define RLE_BIT_SHIFT					14
#define HALF_RLE_SAMPLES				(58)	// half the number of total RLE samples
#define HALF_RLE_BUFFER_SIZE			(348)	// this must be 6* above
#define RLE_SAMPLES						(116)	// this must be 2* 6 * HALF_RLE_SAMPLES
#define RLE_BUFFER_SIZE					(696)	// total size of the buffer
#define CHECK_PERIOD					(30.0)	// in seconds, checking sync period
#define DETECTION_POINTS				(4.0)	// detection sensitivity, the higher the harder to sync.
#define STANDBY_PERIOD					(0x200)
#define ALARM_PERIOD					(0x400)
#define DEFAULT_RX						(0.0320) // in Ohms
#define DEFAULT_AVG_SAMPLE_COUNT		(30.0)
#define DEFAULT_LOG_FLOOR               (0.1)
//
#define DEFAULT_COILRESISTANCE			(50.0)	// in Ohms
#define	DEFAULT_CYCLEPERCENT			(25.0)
#define DEFAULT_RELAYON					(0)		// bit 0= on or off
#define DEFAULT_RELAYENABLE				(1)		// bit 0= global enable disable
#define DEFAULT_CURRENTMAXTIMEOUTPERIOD	(15.0)	// in seconds
#define DEFAULT_LOADCURRENTMAX			(100.0)	// in Amps
#define DEFAULT_RELAYOFFVOLTAGE			(11.5)	// cut off for relay
#define DEFAULT_RELAYHYSTERESIS			(0.5)	// in Volts
//
#define LOG_BATTV				1
#define LOG_TIME				2
#define LOG_LOADA				3
#define LOG_CHARGEA				4
#define LOG_CIRCUITA			5
#define LOG_RELAYA				6
#define LOG_NETA				7
#define LOG_CAPACITYAH			8
#define LOG_CAPACITYPERCENT 	9
#define LOG_TOTAL				9
//
#define SAMPLING_COUNT			(0x6000)	// must be a multiple of (2*ALARM_PERIOD)
//
#define TEMPBUFF_SIZE			40
#define READ_DIR				0
#define WRITE_DIR				1
#define NUM_DIGITS				10
//
#define DEFAULT_VCC					(5.00)
#define DEFAULT_VUSB				(3.30)
#define DEFAULT_LOW_DIVIDER			(12.0)
#define DEFAULT_HIGH_DIVIDER		(12.0)
#define DEFAULT_CHARGING_EFFICIENCY	(80.0)
#define DEFAULT_BRIGHTNESS_PERCENT	(100.0)
#define DEFAULT_TIMEOUT_IN_SECONDS	(15.0)
#define DEFAULT_DIFFERENTIAL_GAIN	(60.0)	// for the MAX4081SASA it is Sixty
#define DEFAULT_SHUNT_RESISTANCE	(1.0)	// in milli Ohms
#define DEFAULT_SENSE_RESISTANCE	(10.0)	// in Ohms
#define DEFAULT_FULLCAPACITY		(20.0)	// in AH
#define DEFAULT_CAPACITY_AS			(DEFAULT_FULLCAPACITY*1800.0)       // set to 50% initially
#define DEFAULT_PEUKERTS			(1.100)	// unit
#define DEFAULT_MINVOLTAGE			(11.0)	// in Volts
#define DEFAULT_MAXVOLTAGE			(13.8)	// in Volts
#define DEFAULT_CHEMISTRY			(1)		// 1=Lead Acid 0=Nickel
#define DEFAULT_LOG_PERIOD			(15.0)	// in seconds
#define DEFAULT_LOG_ERROR			(1.0)	// % sensitivity in the RLE encoding.
#define DEFAULT_THRESHOLD			(0.05)	// in Amps
#define DEFAULT_TRICKLE_CURRENT     (0.25)   // in Amps
//
#define MAX_NUM_MENU				9
#define MENU_STRING_LENGTH			28
#define MENU_STRING_LENGTH_XTENDED	40
#define MENU_STACK_SIZE				6
#define SCROLL_DELAY				600
// The Following are the different display modes
#define SINGLE_MODE_ALL					'0'
#define SINGLE_MODE_CHARGE				'1'
#define	SINGLE_MODE_CAPACITYAH			'2'
#define SINGLE_MODE_VOLTAGE				'3'
#define SINGLE_MODE_LOADCURRENT			'4'
#define SINGLE_MODE_CHARGECURRENT		'5'
#define SINGLE_MODE_CIRCUITCURRENT		'6'
#define SINGLE_MODE_NETBATTERYDRAIN		'7'
#define SINGLE_MODE_TIMEREMAINING		'8'
#define MODE_CIRCUIT					'9'
#define MODE_CURRENT            		'A'		// displays the battery capacity in AH
#define MODE_TIME_REMAINING				'B'		// displays the time remaining/percentage
#define MODE_VOLTAGE_CURRENT			'C'		// displays voltage and current information
#define MODE_CAPACITY     				'D'		// displays settings in scrolling style
#define MODE_ALL_SCROLLING				'*'
#define MODE_DEFAULT					(SINGLE_MODE_CHARGE)
/** V E C T O R  R E M A P P I N G *******************************************/
void myISR(void);
void myISRHigh(void);

typedef unsigned char byte;

typedef union
{
	rom far char *pAdr;
    struct
    {
      byte low;                   //Little-endian order
      byte high;
      byte upper;
    };
} MEM_PTR;

typedef struct
{
	volatile byte 	updated;
	volatile int 	lastSampled;
	volatile double value;
	volatile byte  	avgCount;
	volatile double avgValue;
	volatile double totalValue;
} SAMPLE;

typedef struct
{
	rom char *title;
	void (*function)(int);
	ram double *setting;
	rom char numdec;
	ram char* string;
} MENU_ITEM_BODY;

typedef struct MENU MENU;					// forward declaration...

typedef struct
{
	rom MENU* nextItem;
	rom MENU_ITEM_BODY	body;
} MENU_ITEM;

typedef struct
{
	rom byte numMenus;
	rom MENU_ITEM menu[MAX_NUM_MENU];
} MENU;

#endif
